package v1

import "time"

// Team is a single team.
type Team struct {
	ID                  string `json:"id"`
	Name                string `json:"name"`
	UserID              string `json:"user_id"`
	DisplayName         string `json:"display_name"`
	DescriptionHTML     string `json:"description_html"`
	DescriptionMarkdown string `json:"description_markdown"`

	LogoID             *string `json:"logo_id"`
	LogoURL            *string `json:"logo_url"`
	BannerID           *string `json:"banner_id"`
	BannerURL          *string `json:"banner_url"`
	BackgroundImageID  *string `json:"background_image_id"`
	BackgroundImageURL *string `json:"background_image_url"`

	CreatedAt *time.Time `json:"created_at"`
	UpdatedAt *time.Time `json:"updated_at"`
}

// PatchChannelDisplayPositionRequestParams is the set of required request
// parameters for making a PATCH request to update a channels display position
// in a list. For example in the team membership list, or featured channels list.
type PatchChannelDisplayPositionRequestParams struct {
	TeamID          string
	ChannelID       string
	DisplayPosition *uint
}

// PatchChannelDisplayPositionRequestBody is the body format for PATCH requests
// that update the display position of a channel in certain contexts.
// For example in a team membership list, or featured channels list.
type PatchChannelDisplayPositionRequestBody struct {
	DisplayPosition *uint `json:"display_position"`
}
