package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) DeleteV1TeamInvitation(ctx context.Context, params v1.DeleteTeamInvitationRequestParams, reqOpts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/teams/%s/channels/%s/invitation", params.TeamID, params.ChannelID)

	return c.delete(ctx, path, "team_invitation", reqOpts)
}
