package roster

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1FeaturedChannels makes a GET request to the Roster Service for
// a given team's featured channels.
func (c *clientImpl) GetV1FeaturedChannels(ctx context.Context, params v1.GetFeaturedChannelsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetFeaturedChannelsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/featured_channels", params.TeamID)
	response := &v1.GetFeaturedChannelsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_featured_channels",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
