package roster

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1TeamMemberships makes a GET request to the Roster Service for
// a given team's members.
func (c *clientImpl) GetV1TeamMemberships(ctx context.Context, params v1.GetTeamMembershipsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetTeamMembershipsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/memberships", params.TeamID)
	response := &v1.GetTeamMembershipsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_team_members",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	query := req.URL.Query()

	if params.RevenueRevealed != nil {
		query.Set("revenue_revealed", fmt.Sprint(*params.RevenueRevealed))
	}

	if params.StatsRevealed != nil {
		query.Set("stats_revealed", fmt.Sprint(*params.StatsRevealed))
	}

	req.URL.RawQuery = query.Encode()

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
