package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PatchV1FeaturedChannel(ctx context.Context, params v1.PatchFeaturedChannelRequestParams, opts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/teams/%s/featured_channels/%s", params.TeamID, params.ChannelID)

	reqBody := v1.PatchFeaturedChannelRequestBody{
		DisplayPosition: params.DisplayPosition,
	}

	return c.patch(ctx, path, "featured_channels", reqBody, nil, opts)
}
