package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PatchV1Team(ctx context.Context, params v1.PatchTeamRequestParams, opts *twitchclient.ReqOpts) (*v1.PatchTeamResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s", params.TeamID)
	resp := &v1.PatchTeamResponse{}

	reqBody := v1.PatchTeamRequestBody{
		DisplayName:         params.DisplayName,
		UserID:              params.UserID,
		DescriptionMarkdown: params.DescriptionMarkdown,
		LogoID:              params.LogoID,
		BannerID:            params.BannerID,
		BackgroundImageID:   params.BackgroundImageID,
	}

	err := c.patch(ctx, path, "team", reqBody, resp, opts)
	if err != nil {
		return nil, err
	}

	return resp, nil
}
