package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PatchV1TeamMembership(ctx context.Context, params v1.PatchTeamMembershipRequestParams, opts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/teams/%s/channels/%s/membership", params.TeamID, params.ChannelID)

	reqBody := v1.PatchTeamMembershipRequestBody{
		DisplayPosition: params.DisplayPosition,
	}

	return c.patch(ctx, path, "membership", reqBody, nil, opts)
}
