package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// PostV1ImageUploads makes a POST request to the Roster Service
// to generate an image-upload URL.
func (c *clientImpl) PostV1ImageUploads(ctx context.Context, params v1.PostImageUploadsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.PostImageUploadsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/image_uploads", params.TeamID)
	response := &v1.PostImageUploadsResponse{}

	reqBody := v1.PostImageUploadsRequestBody{
		Category: params.Category,
		FileType: params.FileType,
		Size:     params.Size,
	}

	err := c.post(ctx, path, "image_uploads", reqBody, response, reqOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
