package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// PostV1TeamInvitations makes a POST request to the Roster Service
// to create an invitation for a given team and channel.
func (c *clientImpl) PostV1TeamInvitations(ctx context.Context, params v1.PostTeamInvitationsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.PostTeamInvitationsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/invitations", params.TeamID)
	response := &v1.PostTeamInvitationsResponse{}
	reqBody := v1.PostTeamInvitationsRequestBody{
		ChannelID: params.ChannelID,
	}

	err := c.post(ctx, path, "team_invitations", reqBody, response, reqOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
