package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PostV1Teams(ctx context.Context, params v1.PostTeamsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.PostTeamsResponse, error) {
	path := fmt.Sprintf("/v1/users/%s/teams", params.UserID)
	response := &v1.PostTeamsResponse{}

	reqBody := v1.PostTeamsRequestBody{
		Name:                params.Name,
		DisplayName:         params.DisplayName,
		DescriptionMarkdown: params.DescriptionMarkdown,
	}

	err := c.post(ctx, path, "teams", reqBody, response, reqOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
