package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PutV1ChannelInvitation(ctx context.Context, params v1.PutChannelInvitationRequestParams, opts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/channels/%s/teams/%s/invitation", params.ChannelID, params.TeamID)

	reqBody := v1.PutChannelInvitationRequestBody{
		Accepted: &params.Accepted,
	}

	return c.put(ctx, path, "channel_invitation", reqBody, nil, opts)
}
