package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PutV1ChannelMembership(ctx context.Context, params v1.PutChannelMembershipRequestParams, opts *twitchclient.ReqOpts) error {
	path := fmt.Sprintf("/v1/channels/%s/teams/%s/membership", params.ChannelID, params.TeamID)

	reqBody := v1.PutChannelMembershipRequestBody{
		Primary:         params.Primary,
		RevenueRevealed: &params.RevenueRevealed,
		StatsRevealed:   &params.StatsRevealed,
	}

	return c.put(ctx, path, "channel_membership", reqBody, nil, opts)
}
