package roster

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) post(ctx context.Context, path, stat string, body, resp interface{}, opts *twitchclient.ReqOpts) error {
	buffer := &bytes.Buffer{}

	err := json.NewEncoder(buffer).Encode(&body)
	if err != nil {
		return err
	}

	req, err := c.NewRequest(http.MethodPost, path, buffer)
	if err != nil {
		return err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(opts, twitchclient.ReqOpts{
		StatName:       fmt.Sprintf("service.cb-roster.v1.post_%s", stat),
		StatSampleRate: 0.1,
	})

	if resp == nil {
		resp = struct{}{}
	}

	_, err = c.DoJSON(ctx, resp, req, mergedOpts)
	return err
}

func (c *clientImpl) patch(ctx context.Context, path, stat string, body, resp interface{}, opts *twitchclient.ReqOpts) error {
	buffer := &bytes.Buffer{}

	err := json.NewEncoder(buffer).Encode(body)
	if err != nil {
		return err
	}

	req, err := c.NewRequest(http.MethodPatch, path, buffer)
	if err != nil {
		return err
	}

	req.Header.Set("Content-Type", "application/json")

	if resp == nil {
		resp = struct{}{}
	}

	mergedOpts := twitchclient.MergeReqOpts(opts, twitchclient.ReqOpts{
		StatName:       fmt.Sprintf("service.cb-roster.v1.patch_%s", stat),
		StatSampleRate: 0.1,
	})

	_, err = c.DoJSON(ctx, resp, req, mergedOpts)
	return err
}

func (c *clientImpl) put(ctx context.Context, path, stat string, body, resp interface{}, opts *twitchclient.ReqOpts) error {
	buffer := &bytes.Buffer{}

	err := json.NewEncoder(buffer).Encode(body)
	if err != nil {
		return err
	}

	req, err := c.NewRequest(http.MethodPut, path, buffer)
	if err != nil {
		return err
	}

	req.Header.Set("Content-Type", "application/json")

	if resp == nil {
		resp = struct{}{}
	}

	mergedOpts := twitchclient.MergeReqOpts(opts, twitchclient.ReqOpts{
		StatName:       fmt.Sprintf("service.cb-roster.v1.put_%s", stat),
		StatSampleRate: 0.1,
	})

	_, err = c.DoJSON(ctx, resp, req, mergedOpts)
	return err
}

func (c *clientImpl) delete(ctx context.Context, path, stat string, opts *twitchclient.ReqOpts) error {
	req, err := c.NewRequest(http.MethodDelete, path, nil)
	if err != nil {
		return err
	}

	mergedOpts := twitchclient.MergeReqOpts(opts, twitchclient.ReqOpts{
		StatName:       fmt.Sprintf("service.cb-roster.v1.delete_%s", stat),
		StatSampleRate: 0.1,
	})

	_, err = c.DoJSON(ctx, struct{}{}, req, mergedOpts)
	return err
}
