// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: liveline.proto

/*
Package liveline is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	liveline.proto
*/
package liveline

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Liveline Interface
// ==================

type Liveline interface {
	// GetStreamsByChannelIDs returns live streams that have input channel IDs
	// The streams are sorted by input order.
	// SLO@100ms
	GetStreamsByChannelIDs(context.Context, *StreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetStreamsByChannelNames returns live streams that have input channel names
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByChannelNames(context.Context, *StreamsByChannelNamesRequest) (*StreamsResponse, error)

	// GetStreamsByBroadcastIDs returns live streams that have input broadcast IDs
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByBroadcastIDs(context.Context, *StreamsByBroadcastIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsByChannelIDs returns live streams that have input channel IDs
	// and meet the filter criterion.
	// The streams are sorted by input order by default.
	// SLO@200ms
	GetFilteredStreamsByChannelIDs(context.Context, *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreams returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@290ms
	GetFilteredStreams(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsLarge returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@2500ms
	// This is same as GetFilteredStreams, but with larger page_size and higher SLO
	GetFilteredStreamsLarge(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetStreamSummary aggregates the streams by provided input metadata field
	// and meet StreamSummaryFilter requirements
	// The response includes the total number of viewers and total number of channels for that field
	// The streams are sorted by popularity (CCU) by default.
	// SLO@200ms
	GetStreamSummary(context.Context, *StreamSummaryRequest) (*StreamSummaryResponse, error)
}

// ========================
// Liveline Protobuf Client
// ========================

type livelineProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineProtobufClient creates a Protobuf client that implements the Liveline interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLivelineProtobufClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineProtobufClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Liveline JSON Client
// ====================

type livelineJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineJSONClient creates a JSON client that implements the Liveline interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLivelineJSONClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineJSONClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================
// Liveline Server Handler
// =======================

type livelineServer struct {
	Liveline
	hooks *twirp.ServerHooks
}

func NewLivelineServer(svc Liveline, hooks *twirp.ServerHooks) TwirpServer {
	return &livelineServer{
		Liveline: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *livelineServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LivelinePathPrefix is used for all URL paths on a twirp Liveline server.
// Requests are always: POST LivelinePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LivelinePathPrefix = "/twirp/liveline.Liveline/"

func (s *livelineServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/liveline.Liveline/GetStreamsByChannelIDs":
		s.serveGetStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByChannelNames":
		s.serveGetStreamsByChannelNames(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByBroadcastIDs":
		s.serveGetStreamsByBroadcastIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsByChannelIDs":
		s.serveGetFilteredStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreams":
		s.serveGetFilteredStreams(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsLarge":
		s.serveGetFilteredStreamsLarge(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamSummary":
		s.serveGetStreamSummary(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelNamesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByBroadcastIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByBroadcastIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByBroadcastIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByBroadcastIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLarge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsLargeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsLargeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsLargeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLargeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummary(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamSummaryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamSummaryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamSummaryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamSummaryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummaryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamSummaryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *livelineServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2699 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4d, 0x6f, 0xe3, 0xc8,
	0xd1, 0x7e, 0x25, 0x59, 0xb6, 0x54, 0xf2, 0x07, 0xdd, 0xf6, 0x78, 0x3c, 0x9e, 0x9d, 0x1d, 0xaf,
	0x66, 0x31, 0x98, 0x35, 0x16, 0x9e, 0x37, 0xde, 0x6c, 0x90, 0x45, 0x82, 0x04, 0xb4, 0x44, 0x4b,
	0xc2, 0xca, 0x96, 0xd3, 0xd2, 0x78, 0x33, 0x01, 0x02, 0xa2, 0x4d, 0xb6, 0x25, 0x66, 0x24, 0x91,
	0x21, 0x5b, 0x9e, 0xd5, 0xdc, 0x12, 0x20, 0xc8, 0x2d, 0xc8, 0x31, 0x97, 0x7c, 0x1c, 0x82, 0x00,
	0x41, 0x4e, 0x7b, 0xd9, 0x73, 0x7e, 0x40, 0xfe, 0x41, 0x80, 0xfc, 0x86, 0xdc, 0x72, 0x0d, 0xfa,
	0x8b, 0xa4, 0x28, 0x8d, 0x27, 0x86, 0x91, 0xdc, 0xc8, 0xa7, 0x9e, 0xaa, 0xae, 0xae, 0xae, 0xae,
	0xae, 0x26, 0x61, 0x7d, 0xe8, 0x5d, 0xd3, 0xa1, 0x37, 0xa6, 0x87, 0x41, 0xe8, 0x33, 0x1f, 0x95,
	0xf4, 0xfb, 0xde, 0xe3, 0xbe, 0xef, 0xf7, 0x87, 0xf4, 0xb9, 0xc0, 0x2f, 0x27, 0x57, 0xcf, 0x99,
	0x37, 0xa2, 0x11, 0x23, 0xa3, 0x40, 0x52, 0xab, 0xbf, 0xc9, 0xc1, 0x5e, 0x97, 0x85, 0x94, 0x8c,
	0xa2, 0xe3, 0x69, 0x6d, 0x40, 0xc6, 0x63, 0x3a, 0x6c, 0xd5, 0x23, 0x4c, 0x7f, 0x3a, 0xa1, 0x11,
	0x43, 0x8f, 0xa1, 0xe2, 0x48, 0xd0, 0xf6, 0xdc, 0x68, 0x37, 0xb7, 0x5f, 0x78, 0x56, 0xc6, 0xa0,
	0xa0, 0x96, 0x1b, 0xa1, 0x43, 0x28, 0x45, 0x7e, 0xc8, 0xec, 0x57, 0x74, 0xba, 0x9b, 0xdf, 0xcf,
	0x3d, 0x5b, 0x3f, 0xda, 0x3a, 0x8c, 0xbd, 0xe9, 0xfa, 0x21, 0x3b, 0xf1, 0xe8, 0xd0, 0xc5, 0x2b,
	0x9c, 0xf4, 0x39, 0x9d, 0xa2, 0x8f, 0xa0, 0xe8, 0x87, 0x2e, 0x0d, 0x77, 0x0b, 0x8b, 0xc8, 0x1d,
	0x2e, 0xc2, 0x92, 0x51, 0xfd, 0x5d, 0x0e, 0xde, 0xcb, 0xba, 0x76, 0x46, 0x46, 0x34, 0x76, 0xee,
	0x09, 0xac, 0x69, 0xe7, 0xc6, 0x1c, 0x57, 0xee, 0xad, 0x3a, 0x29, 0xee, 0xff, 0xcc, 0xc1, 0xe3,
	0xd0, 0x27, 0xae, 0x43, 0x22, 0x96, 0x8a, 0xde, 0x13, 0x58, 0xbb, 0xd4, 0x70, 0x2a, 0x7e, 0xab,
	0x31, 0xf8, 0x5f, 0x8e, 0xe0, 0x5f, 0x73, 0xb0, 0x2d, 0x1d, 0xec, 0x4e, 0x46, 0x23, 0x12, 0x4e,
	0xb5, 0x63, 0x9f, 0xc2, 0xca, 0x95, 0x37, 0x64, 0x34, 0x94, 0x2e, 0x55, 0x8e, 0x1e, 0x26, 0x56,
	0xcc, 0x7e, 0x3f, 0xa4, 0x7d, 0xc2, 0x3c, 0x7f, 0x7c, 0x22, 0x38, 0x58, 0x73, 0xd1, 0xa7, 0x50,
	0xea, 0x87, 0xfe, 0x24, 0xb0, 0x2f, 0xb5, 0xab, 0x7b, 0x6f, 0xd1, 0x13, 0x1e, 0x0b, 0xee, 0xf1,
	0x14, 0x3d, 0x02, 0x08, 0x48, 0x9f, 0xda, 0xcc, 0x7f, 0x45, 0xc7, 0xc2, 0xed, 0x32, 0x2e, 0x73,
	0xa4, 0xc7, 0x01, 0xf4, 0x10, 0xc4, 0x8b, 0x1d, 0x79, 0x6f, 0xe8, 0xee, 0xd2, 0x7e, 0xee, 0x59,
	0x01, 0x97, 0x38, 0xd0, 0xf5, 0xde, 0xd0, 0xea, 0x14, 0x36, 0xe7, 0x1c, 0x42, 0xdf, 0x07, 0x90,
	0x2e, 0x89, 0xa0, 0xe5, 0x84, 0x27, 0xfb, 0x37, 0xcc, 0x40, 0xfa, 0x53, 0x96, 0x3a, 0x3c, 0x86,
	0x4f, 0x60, 0x4d, 0x19, 0xb8, 0x26, 0xc3, 0x09, 0x8d, 0x76, 0xf3, 0x72, 0x61, 0x24, 0x78, 0x21,
	0xb0, 0xaa, 0x0d, 0xcb, 0x6a, 0xbc, 0xa3, 0x05, 0xe3, 0xa5, 0xe2, 0x7e, 0xa2, 0xed, 0xa6, 0x87,
	0xf8, 0x00, 0x56, 0xd3, 0x43, 0xa8, 0x11, 0x2a, 0xa9, 0x11, 0xaa, 0x7f, 0xcb, 0x41, 0x55, 0xea,
	0x52, 0xf7, 0x2e, 0x7b, 0xf0, 0x20, 0x59, 0xcd, 0xbc, 0x58, 0x4d, 0x23, 0xeb, 0x5b, 0xb2, 0x84,
	0xe9, 0x6c, 0x2b, 0xdc, 0x26, 0xdb, 0x96, 0xde, 0x99, 0x6d, 0x7f, 0xcf, 0xc1, 0x4e, 0x66, 0x3a,
	0x7a, 0x0a, 0x07, 0xd9, 0x7c, 0xbb, 0xc1, 0xc3, 0x99, 0x74, 0xc8, 0xcf, 0xa6, 0xc3, 0xbb, 0x52,
	0x29, 0x3d, 0xbb, 0xa5, 0xdb, 0xcc, 0xae, 0xf8, 0xce, 0xd9, 0xb9, 0xb0, 0x11, 0x4f, 0x2a, 0x0a,
	0xfc, 0x71, 0x44, 0xd1, 0x11, 0xac, 0x44, 0x12, 0x52, 0xb3, 0xda, 0x4d, 0xe9, 0x0b, 0x81, 0xa6,
	0x62, 0x4d, 0xcc, 0x4c, 0x20, 0x9f, 0x99, 0x40, 0xf5, 0xb7, 0xcb, 0xb0, 0x3e, 0xab, 0xca, 0x35,
	0x92, 0xe5, 0x17, 0xc9, 0x57, 0xc6, 0xe5, 0x78, 0xf5, 0x79, 0x9e, 0xa5, 0x8b, 0xa0, 0x32, 0x59,
	0x49, 0xd5, 0x40, 0x4e, 0x49, 0x97, 0x21, 0x11, 0xb6, 0x02, 0xae, 0xa4, 0xaa, 0x10, 0xfa, 0x0e,
	0xac, 0xf5, 0x43, 0x72, 0x75, 0xe5, 0x31, 0xcf, 0x76, 0x09, 0x23, 0x22, 0x7a, 0x95, 0xa3, 0x9d,
	0x64, 0x42, 0x0d, 0x25, 0xae, 0x13, 0x46, 0xf0, 0x6a, 0x3f, 0xf5, 0x86, 0xbe, 0x9d, 0xb8, 0x20,
	0x74, 0x8b, 0x42, 0xf7, 0x5e, 0xa2, 0xab, 0x72, 0x5a, 0xa8, 0x6a, 0xcf, 0x84, 0xe6, 0x11, 0xc0,
	0x24, 0x1a, 0xd0, 0x50, 0xea, 0x2d, 0x0b, 0xbd, 0xd4, 0x22, 0xbc, 0xe0, 0x32, 0xa1, 0x55, 0x9e,
	0xe8, 0x47, 0xe1, 0x2a, 0x19, 0x51, 0x7b, 0x44, 0x19, 0x11, 0x6a, 0x2b, 0x73, 0xae, 0x92, 0x11,
	0x3d, 0x55, 0x52, 0xbc, 0xda, 0x4f, 0xbd, 0xa1, 0x3a, 0x18, 0x01, 0x09, 0xd9, 0x98, 0x86, 0xd1,
	0xc0, 0x0b, 0xe4, 0xb0, 0x25, 0xa1, 0xff, 0x20, 0xd1, 0x3f, 0x4f, 0x18, 0x62, 0xf0, 0x8d, 0x60,
	0x16, 0x10, 0x56, 0x86, 0x64, 0x1a, 0x31, 0x51, 0x63, 0xa4, 0x95, 0xf2, 0x9c, 0x95, 0x84, 0xa1,
	0xac, 0xcc, 0x02, 0xe8, 0x7b, 0xb0, 0x7e, 0xed, 0xd1, 0xd7, 0x8e, 0x3f, 0x19, 0x33, 0x69, 0x03,
	0x84, 0x8d, 0xfb, 0x89, 0x8d, 0x0b, 0x2d, 0x17, 0x16, 0xd6, 0xae, 0xd3, 0xaf, 0xa8, 0x0d, 0x3b,
	0xf1, 0x9a, 0x39, 0x84, 0xd1, 0xbe, 0x1f, 0x4e, 0xa5, 0x9d, 0xca, 0x8d, 0x8b, 0xb7, 0xad, 0xb5,
	0x6a, 0x4a, 0x49, 0x58, 0x7b, 0x0e, 0xe5, 0x49, 0xa4, 0x57, 0x62, 0x55, 0x18, 0x40, 0xe9, 0x95,
	0x50, 0x0b, 0x51, 0x9a, 0xa8, 0x27, 0xd4, 0x80, 0xcd, 0x90, 0x46, 0x2c, 0xf4, 0x1c, 0x3e, 0xa3,
	0x48, 0x2a, 0xae, 0x09, 0xc5, 0xd4, 0xa9, 0x80, 0x53, 0x14, 0x61, 0xc0, 0x08, 0x33, 0x08, 0x3a,
	0x80, 0x4d, 0xb9, 0x3b, 0xec, 0xd4, 0xce, 0x58, 0x17, 0x69, 0xbc, 0x21, 0x05, 0xe7, 0xf1, 0xfe,
	0x18, 0xc0, 0xda, 0x4c, 0x4c, 0xd0, 0x7b, 0x50, 0x8e, 0xa3, 0x22, 0x36, 0x47, 0x01, 0x27, 0x00,
	0xfa, 0x0c, 0x60, 0x12, 0xb8, 0x84, 0x51, 0xd7, 0x26, 0x4c, 0x6c, 0x0d, 0xee, 0x9c, 0xec, 0x89,
	0x0e, 0x75, 0x4f, 0x74, 0xd8, 0xd3, 0x3d, 0x11, 0x2e, 0x2b, 0xb6, 0xc9, 0xaa, 0x5f, 0xe7, 0x60,
	0x35, 0x1d, 0x36, 0xf4, 0x11, 0x2c, 0x31, 0xd2, 0xd7, 0x5b, 0xfd, 0xde, 0x7c, 0x70, 0x7b, 0xa4,
	0x8f, 0x05, 0x45, 0x6c, 0x59, 0x7f, 0xcc, 0xe8, 0x58, 0x6c, 0x37, 0xb5, 0xc9, 0x15, 0xa2, 0xb6,
	0xac, 0x12, 0xb3, 0x69, 0x40, 0xf5, 0x7e, 0x54, 0x58, 0x6f, 0x1a, 0xd0, 0x8c, 0xe3, 0x4b, 0xb7,
	0x71, 0xfc, 0x0d, 0x54, 0x52, 0x1e, 0xa1, 0x7b, 0xb0, 0xcc, 0x48, 0x3f, 0x29, 0x1d, 0x45, 0x46,
	0xfa, 0x2d, 0x17, 0x3d, 0x80, 0x12, 0x87, 0x53, 0x25, 0x63, 0x85, 0x91, 0xbe, 0x28, 0x17, 0x77,
	0x18, 0xfb, 0xf7, 0x79, 0xa8, 0xa4, 0x36, 0xbb, 0x38, 0xba, 0x74, 0x66, 0x2a, 0x0f, 0x8a, 0x18,
	0x34, 0xd4, 0x72, 0x45, 0x0b, 0xa7, 0x09, 0x29, 0x5f, 0x56, 0x35, 0x28, 0x1c, 0xfa, 0x08, 0x0c,
	0xd7, 0x0b, 0xa9, 0xc3, 0x38, 0x6b, 0xe0, 0xb9, 0xae, 0x2a, 0xfd, 0x25, 0xbc, 0x11, 0xe3, 0x4d,
	0x01, 0xf3, 0xc3, 0xc3, 0x8b, 0xec, 0x11, 0x61, 0x93, 0x50, 0xf6, 0x12, 0x25, 0x5c, 0xf2, 0xa2,
	0x53, 0xf1, 0x8e, 0xbe, 0x01, 0xdb, 0x71, 0xcd, 0xa3, 0xa1, 0x3d, 0x24, 0xe3, 0xfe, 0x84, 0xf4,
	0xa9, 0xa8, 0x57, 0x65, 0xbc, 0x95, 0x92, 0xb5, 0x95, 0x08, 0x6d, 0x43, 0x91, 0x79, 0x6c, 0x48,
	0x45, 0x6d, 0xe2, 0xc1, 0xe3, 0x2f, 0x99, 0x08, 0xad, 0xdc, 0x26, 0x42, 0xff, 0x2c, 0x40, 0x39,
	0x2e, 0x6b, 0xe8, 0x3e, 0xac, 0x4c, 0x02, 0x9b, 0xf7, 0xe4, 0x2a, 0x36, 0xcb, 0x93, 0x80, 0xab,
	0x65, 0x5d, 0x8d, 0xfc, 0x2b, 0xf6, 0x9a, 0x84, 0x3a, 0x3c, 0x69, 0x57, 0xbb, 0x4a, 0x84, 0x0c,
	0x28, 0x0c, 0x86, 0x91, 0x08, 0x4c, 0x11, 0xf3, 0x47, 0x1e, 0x7d, 0x72, 0xed, 0xd8, 0x41, 0xe8,
	0x5f, 0x79, 0x43, 0x19, 0x8e, 0x32, 0x06, 0x72, 0xed, 0x9c, 0x4b, 0x84, 0x47, 0x8b, 0x13, 0x86,
	0xf4, 0x9a, 0x0e, 0x55, 0x14, 0x4a, 0xe4, 0xda, 0x69, 0xf3, 0x77, 0x9e, 0xa5, 0xd7, 0x9e, 0x4b,
	0x7d, 0x7b, 0x40, 0xbd, 0xfe, 0x80, 0x89, 0x08, 0x14, 0x71, 0x45, 0x60, 0x4d, 0x01, 0xf1, 0x01,
	0x24, 0xe5, 0xb5, 0xe7, 0xb2, 0x81, 0x08, 0x44, 0x11, 0x83, 0x80, 0xbe, 0xe0, 0x48, 0x42, 0x70,
	0x7c, 0x97, 0x3a, 0xa2, 0xd2, 0x96, 0x15, 0xa1, 0xc6, 0x11, 0xbe, 0xfe, 0x92, 0x70, 0xe9, 0xb1,
	0x90, 0x30, 0x2a, 0xca, 0x68, 0x11, 0xcb, 0x91, 0x8f, 0x25, 0xc6, 0x67, 0x76, 0x15, 0x44, 0xa2,
	0x3a, 0x16, 0x31, 0x7f, 0xe4, 0xbb, 0x9e, 0x8e, 0x9d, 0x70, 0x1a, 0x30, 0xea, 0x8a, 0x6a, 0x57,
	0xc4, 0x09, 0x90, 0x0d, 0x5e, 0x30, 0x24, 0xec, 0xca, 0x0f, 0x47, 0xa2, 0xaa, 0xcd, 0x06, 0xef,
	0x5c, 0x89, 0x32, 0x2b, 0xba, 0x76, 0x8b, 0x15, 0xe5, 0x73, 0x54, 0xe5, 0x4b, 0x6c, 0x66, 0x59,
	0xb8, 0x40, 0x42, 0x7c, 0x2f, 0x57, 0xff, 0x98, 0x87, 0xd5, 0xf4, 0x91, 0xc4, 0x4b, 0xad, 0x13,
	0xf5, 0x7d, 0x59, 0x31, 0x73, 0xd9, 0x52, 0x5b, 0xeb, 0x36, 0x3a, 0xb2, 0xd4, 0x72, 0x92, 0x48,
	0x93, 0x8f, 0xa1, 0x34, 0xf4, 0xd5, 0xe1, 0x2a, 0x8b, 0xd8, 0x66, 0xc2, 0x6f, 0x77, 0xda, 0x82,
	0xbe, 0x32, 0xf4, 0x87, 0xba, 0x92, 0x07, 0x93, 0xcb, 0xbe, 0xa4, 0x17, 0xb2, 0xe6, 0xcf, 0x5f,
	0x1c, 0x37, 0xa4, 0x79, 0x4e, 0xd2, 0x07, 0x91, 0x7f, 0x4d, 0xc3, 0xd7, 0x84, 0x39, 0x83, 0xf4,
	0xe9, 0x9f, 0x3a, 0x88, 0x3a, 0x5a, 0x2e, 0x0f, 0x22, 0x3f, 0xfd, 0xca, 0x8f, 0xc3, 0x01, 0x25,
	0x21, 0x1b, 0x44, 0xcc, 0x1f, 0xd3, 0x74, 0x0f, 0x90, 0x3a, 0x0e, 0x9b, 0x09, 0x43, 0x1e, 0x87,
	0x83, 0x59, 0xa0, 0xfa, 0x97, 0x1c, 0x94, 0xf4, 0xdc, 0xf9, 0x92, 0x8f, 0x48, 0xa0, 0x4a, 0x16,
	0x7f, 0xe4, 0x05, 0x6b, 0x44, 0x82, 0x99, 0x82, 0x35, 0x22, 0x81, 0xa8, 0x0f, 0xf7, 0x81, 0x3f,
	0xda, 0xde, 0xa8, 0xaf, 0x3a, 0xc2, 0xe5, 0x11, 0x09, 0x5a, 0xa3, 0x3e, 0x7a, 0x1f, 0x20, 0x0a,
	0xa8, 0xc3, 0x08, 0xf3, 0xc3, 0x48, 0x4c, 0xaa, 0x88, 0x53, 0x48, 0x66, 0xd5, 0x8b, 0xb7, 0xd9,
	0xc7, 0x3f, 0xcf, 0xc3, 0x8a, 0x8a, 0xbc, 0xc8, 0x80, 0xc9, 0x68, 0xe4, 0x8f, 0x69, 0x98, 0xaa,
	0x72, 0x1a, 0x6a, 0xb9, 0xaa, 0x83, 0x1f, 0x05, 0xbc, 0x59, 0x50, 0x07, 0x42, 0x51, 0x74, 0xf0,
	0x02, 0x92, 0x27, 0x82, 0x17, 0xd9, 0x8e, 0x3f, 0x1e, 0x53, 0x87, 0xa7, 0xb4, 0xac, 0x6e, 0x15,
	0x2f, 0xaa, 0x69, 0x88, 0xef, 0x94, 0x78, 0x90, 0x90, 0x8c, 0x5f, 0xa9, 0xed, 0xbc, 0xaa, 0x41,
	0x4c, 0xc6, 0xaf, 0xd0, 0x11, 0xdc, 0x9b, 0x21, 0xd9, 0xe3, 0xc9, 0x88, 0x86, 0x9e, 0x23, 0xe6,
	0x56, 0xc4, 0x5b, 0x69, 0xf2, 0x99, 0x14, 0x65, 0x82, 0xb0, 0x7c, 0x9b, 0x20, 0xfc, 0x3a, 0x07,
	0x25, 0x9d, 0x4f, 0xe8, 0x63, 0x40, 0xbc, 0xc3, 0xa1, 0xa1, 0x4d, 0xf8, 0xa2, 0xdb, 0xc9, 0x91,
	0x5c, 0xc4, 0x86, 0x94, 0x98, 0x5c, 0x50, 0x13, 0x27, 0xf3, 0x43, 0x28, 0xcb, 0x2e, 0xce, 0x77,
	0xf5, 0x7a, 0x96, 0x44, 0xa7, 0xe6, 0xbb, 0xd9, 0xfa, 0x5a, 0xb8, 0x8d, 0x4b, 0x3f, 0xcb, 0xc3,
	0xda, 0x4c, 0xb2, 0xa2, 0x63, 0x78, 0x94, 0xae, 0x06, 0xce, 0x80, 0x84, 0xc4, 0xe1, 0x4f, 0xe4,
	0xd2, 0x1b, 0x7a, 0x6c, 0xaa, 0x92, 0xec, 0x61, 0x8a, 0x54, 0xd3, 0x1c, 0x53, 0x52, 0xd0, 0x77,
	0x61, 0x6f, 0xb1, 0x8d, 0xd0, 0x1f, 0x6a, 0xf7, 0x77, 0x17, 0x19, 0xc0, 0xfe, 0x90, 0xa2, 0x4f,
	0xe0, 0xde, 0x42, 0x6d, 0x95, 0xad, 0xdb, 0x8b, 0x14, 0xef, 0x72, 0x0a, 0x7f, 0x95, 0x87, 0x8d,
	0xcc, 0x76, 0xe3, 0x99, 0x91, 0xf6, 0x61, 0x40, 0x43, 0x5f, 0xee, 0xa5, 0xdc, 0x5c, 0x51, 0x6c,
	0xd2, 0xd0, 0x17, 0xfb, 0xea, 0x9b, 0xb0, 0x33, 0xa7, 0xe3, 0x0c, 0x49, 0x14, 0xa9, 0x19, 0x6f,
	0x67, 0x94, 0x6a, 0x5c, 0xc6, 0xf3, 0xc0, 0x0f, 0x02, 0x7f, 0xcc, 0xdb, 0x9b, 0x64, 0x18, 0x39,
	0x55, 0x43, 0x4b, 0xe2, 0x31, 0x0e, 0x61, 0x6b, 0x96, 0x2d, 0x07, 0x90, 0xc9, 0xbd, 0x99, 0xa6,
	0x4b, 0xeb, 0x33, 0x79, 0x53, 0xbc, 0x31, 0x6f, 0x6e, 0x95, 0xca, 0x5f, 0xe5, 0x60, 0x23, 0xd3,
	0xf7, 0xf3, 0x36, 0xce, 0x8b, 0x6c, 0xd5, 0xfc, 0x8b, 0x40, 0x95, 0x70, 0xd9, 0x8b, 0x14, 0x4d,
	0x6d, 0x5a, 0xde, 0x69, 0x0d, 0x3d, 0x7e, 0x74, 0xe5, 0xf5, 0xa6, 0x35, 0x35, 0xa4, 0x28, 0x2e,
	0x3f, 0x4f, 0xfd, 0x40, 0x2d, 0xb8, 0xa0, 0xd4, 0x35, 0x74, 0x97, 0x75, 0xfe, 0x65, 0x01, 0x36,
	0x32, 0xb7, 0x0c, 0x3e, 0x62, 0xe4, 0xd0, 0xe4, 0xcc, 0x93, 0xcb, 0x5b, 0x89, 0x1c, 0x1a, 0x9f,
	0x75, 0x87, 0xb0, 0xc5, 0x29, 0xa2, 0x95, 0xb1, 0x09, 0x63, 0xa1, 0x77, 0x39, 0x61, 0x3a, 0x8b,
	0x37, 0x23, 0x87, 0xf6, 0xb8, 0xc4, 0xd4, 0x02, 0xf4, 0x14, 0x36, 0x12, 0x7e, 0x9f, 0x8e, 0x43,
	0xbd, 0x9a, 0x6b, 0x9a, 0xdb, 0xe0, 0x20, 0xda, 0x97, 0x43, 0x4b, 0x9e, 0xe7, 0xea, 0x7e, 0x43,
	0x93, 0x5a, 0x2e, 0x4f, 0x8d, 0x84, 0x91, 0x69, 0xbf, 0x0c, 0xcd, 0x8b, 0x7b, 0xaf, 0x0f, 0x61,
	0x3d, 0x61, 0x8b, 0x24, 0x5a, 0x56, 0x25, 0x4f, 0x31, 0x17, 0x74, 0xab, 0xb7, 0xe9, 0xc5, 0x50,
	0x13, 0x3e, 0x48, 0x06, 0x08, 0x42, 0x1a, 0x51, 0x66, 0x33, 0xfa, 0x25, 0xb3, 0x5d, 0x1a, 0x39,
	0xa1, 0x17, 0xf0, 0xa0, 0xaa, 0x9e, 0xe5, 0x91, 0x1e, 0xf3, 0x5c, 0xd0, 0x7a, 0xf4, 0x4b, 0x56,
	0x4f, 0x48, 0xd5, 0x7f, 0xe4, 0xa0, 0xa4, 0xaf, 0x48, 0x7c, 0x09, 0xc4, 0x4d, 0x4a, 0x5d, 0x74,
	0xf5, 0x12, 0x70, 0x4c, 0xf5, 0xc6, 0xfc, 0xca, 0x23, 0x2f, 0x5b, 0x5e, 0xc4, 0x2b, 0x63, 0xfa,
	0x54, 0xdb, 0x10, 0x17, 0x2c, 0x89, 0x8b, 0x09, 0x3e, 0x81, 0x35, 0x69, 0x4e, 0xb5, 0xc4, 0x2a,
	0xf8, 0x62, 0x0c, 0x7d, 0x83, 0x8b, 0x49, 0x71, 0x50, 0x97, 0x12, 0x52, 0x1c, 0xd0, 0x3b, 0x1c,
	0x77, 0x7f, 0xc8, 0x81, 0x91, 0xbd, 0xca, 0xa1, 0x7d, 0xa8, 0xa4, 0x2e, 0x73, 0x7a, 0x9e, 0x29,
	0xe8, 0x0e, 0xf7, 0x2f, 0xf4, 0x1c, 0xb6, 0x52, 0x96, 0x6c, 0x5f, 0x04, 0x9a, 0xb7, 0xb7, 0x85,
	0x67, 0x65, 0x8c, 0x52, 0xa2, 0x8e, 0x94, 0x54, 0x7f, 0x91, 0x83, 0x7b, 0x99, 0x8f, 0x9d, 0xea,
	0x0b, 0xca, 0x29, 0x6c, 0xab, 0x0e, 0x2d, 0x92, 0x12, 0xdb, 0x63, 0x74, 0xb4, 0xe0, 0xd3, 0xe7,
	0x8c, 0x7a, 0x8b, 0xd1, 0x11, 0x46, 0x51, 0x16, 0x7a, 0xe7, 0x27, 0x9c, 0x3f, 0xe7, 0x60, 0x73,
	0xce, 0x10, 0xda, 0x83, 0x92, 0xca, 0x87, 0x48, 0x9d, 0x89, 0xf1, 0xfb, 0xec, 0x1d, 0x36, 0x9f,
	0xbd, 0xc3, 0x3e, 0x86, 0x8a, 0xfc, 0xe8, 0x2a, 0xbf, 0x23, 0xca, 0xd5, 0x07, 0x01, 0x89, 0xcf,
	0x88, 0xe8, 0x33, 0x78, 0x90, 0x99, 0x5e, 0xca, 0x3d, 0x99, 0x07, 0x3b, 0x33, 0xd3, 0x88, 0xaf,
	0xd3, 0x07, 0xdf, 0x82, 0x72, 0xfc, 0x55, 0x0c, 0x6d, 0xc1, 0x46, 0xb7, 0x83, 0x7b, 0x27, 0x2d,
	0xab, 0x5d, 0xb7, 0x5f, 0x9c, 0x75, 0xad, 0x9e, 0xf1, 0x7f, 0x68, 0x05, 0x0a, 0xb5, 0xda, 0x85,
	0x91, 0x43, 0x15, 0x58, 0xc1, 0x56, 0xcd, 0x3a, 0xab, 0xbd, 0x34, 0xf2, 0x07, 0x9f, 0x48, 0x3d,
	0xf1, 0x81, 0x4c, 0xeb, 0x75, 0x70, 0xdd, 0xc2, 0xb1, 0x5e, 0x09, 0x96, 0xea, 0x56, 0xb7, 0x66,
	0xe4, 0xb8, 0x05, 0xb3, 0x5b, 0x33, 0xf2, 0x07, 0x5f, 0x17, 0xa0, 0x1c, 0x7f, 0x2a, 0xe5, 0x5a,
	0x27, 0xad, 0x76, 0xcf, 0xc2, 0x9f, 0x5b, 0x2f, 0x63, 0xad, 0x0d, 0xa8, 0xd4, 0xcc, 0x9e, 0xd5,
	0xe8, 0xe0, 0x97, 0x76, 0xab, 0x6e, 0xe4, 0xd0, 0x26, 0xac, 0xc5, 0xc0, 0x99, 0x79, 0x6a, 0x19,
	0x79, 0xce, 0xe9, 0x99, 0x0d, 0xbb, 0x55, 0xef, 0xda, 0xe6, 0x59, 0xdd, 0x28, 0x70, 0x0e, 0x07,
	0xb8, 0x58, 0x42, 0x4b, 0x68, 0x17, 0xb6, 0x8f, 0x71, 0xc7, 0xac, 0xd7, 0xcc, 0x6e, 0xcf, 0xc2,
	0x76, 0xb7, 0x73, 0xd2, 0xfb, 0xc2, 0xc4, 0x96, 0x51, 0xcc, 0x4a, 0xce, 0xdb, 0x66, 0xef, 0xa4,
	0x83, 0x4f, 0x8d, 0xe5, 0xac, 0xa4, 0x6d, 0x9e, 0x35, 0x5e, 0x98, 0x0d, 0xcb, 0x58, 0xe1, 0x23,
	0xbe, 0xe8, 0x5a, 0xd8, 0xc6, 0x56, 0xa3, 0xd5, 0x39, 0x33, 0x4a, 0x1c, 0xe8, 0xf6, 0xb0, 0x65,
	0x9e, 0xda, 0xbd, 0x97, 0xe7, 0x96, 0x51, 0xe6, 0x73, 0x6c, 0xb6, 0xbb, 0x06, 0x70, 0x89, 0x79,
	0x51, 0xb3, 0xcf, 0x71, 0xe7, 0xa4, 0xd5, 0xb6, 0x8c, 0x0a, 0x9f, 0xe6, 0xa9, 0xf9, 0x43, 0x3b,
	0x0d, 0xae, 0x72, 0x8f, 0x35, 0xd8, 0xb6, 0x2e, 0xac, 0xb6, 0xb1, 0x86, 0xd6, 0x01, 0x38, 0xd4,
	0xb4, 0x5a, 0x8d, 0x66, 0xcf, 0x58, 0x47, 0xdb, 0x60, 0x60, 0xab, 0xdb, 0xc3, 0xad, 0x5a, 0xaf,
	0xd5, 0x39, 0x93, 0xe3, 0x6c, 0x70, 0xb4, 0xde, 0xc2, 0x56, 0xad, 0xc7, 0xe3, 0xd1, 0x6c, 0xd5,
	0xeb, 0xd6, 0x99, 0x61, 0x70, 0xcf, 0xe3, 0x20, 0xa5, 0x43, 0xb3, 0x89, 0xf6, 0x60, 0x67, 0x46,
	0x92, 0xc4, 0x08, 0x71, 0xad, 0xf3, 0xb6, 0xf9, 0xb2, 0xdb, 0x33, 0xc5, 0x08, 0x71, 0x24, 0xb6,
	0xb8, 0x2f, 0xda, 0x4c, 0x07, 0x1b, 0xdb, 0x07, 0x7f, 0xca, 0x81, 0x91, 0xfd, 0xba, 0xcf, 0x4d,
	0x9b, 0x8d, 0x06, 0xb6, 0x1a, 0x42, 0x7d, 0x36, 0x69, 0xf6, 0xe1, 0xbd, 0x39, 0xd9, 0xec, 0xba,
	0x1e, 0xc0, 0xd3, 0x39, 0x46, 0xd3, 0x32, 0x71, 0xaf, 0xd9, 0xed, 0x75, 0xce, 0x2c, 0xbb, 0x69,
	0xe1, 0x8e, 0x5e, 0xf0, 0x67, 0xf0, 0xe1, 0x1c, 0xb7, 0x73, 0x61, 0xe1, 0x2f, 0xcc, 0x5e, 0xad,
	0x69, 0xd7, 0x9a, 0x26, 0x36, 0x6b, 0x3d, 0x0b, 0x1b, 0x85, 0x83, 0x7f, 0xe5, 0x60, 0x67, 0xf1,
	0xc7, 0x7f, 0xf4, 0x10, 0xee, 0xcf, 0x18, 0xe1, 0x99, 0x17, 0xfb, 0xfb, 0x14, 0xaa, 0xf3, 0xc2,
	0x6c, 0x48, 0x8d, 0xdc, 0x9c, 0x27, 0xf3, 0x3c, 0x11, 0x60, 0x23, 0x8f, 0x3e, 0x80, 0x47, 0x37,
	0x30, 0x5b, 0x3c, 0x6d, 0x9f, 0xc0, 0xe3, 0x1b, 0x28, 0x62, 0xee, 0x4b, 0x8b, 0x3d, 0x9b, 0x4b,
	0x81, 0xe2, 0xd1, 0xaf, 0x8a, 0x50, 0x6a, 0xab, 0x32, 0x86, 0x5e, 0xc2, 0x4e, 0x83, 0xb2, 0x05,
	0x7f, 0x14, 0xd0, 0x87, 0xd9, 0x5a, 0xb7, 0xe8, 0x87, 0xc3, 0xde, 0x83, 0x39, 0x56, 0x5c, 0x4a,
	0x7f, 0x0c, 0xbb, 0x0b, 0x4c, 0xcb, 0x3f, 0x6d, 0x4f, 0xdf, 0x6e, 0x3c, 0xfd, 0xdb, 0xee, 0x16,
	0xe6, 0xd3, 0xff, 0xd4, 0x16, 0x9a, 0x5f, 0xf0, 0xd3, 0xed, 0x26, 0xf3, 0x1e, 0xbc, 0xdf, 0xa0,
	0xec, 0x86, 0x5f, 0x2e, 0xe8, 0xe3, 0xec, 0x7f, 0x89, 0x9b, 0xfe, 0xcc, 0xdc, 0x34, 0xd4, 0x0f,
	0x00, 0xcd, 0x0f, 0x85, 0xf6, 0xdf, 0x6a, 0xfe, 0x3f, 0x30, 0x79, 0x01, 0xf7, 0xe7, 0x4d, 0xb6,
	0x49, 0xd8, 0xa7, 0x77, 0xb3, 0xdb, 0x05, 0x23, 0x0e, 0xba, 0x3a, 0x21, 0xd0, 0xfb, 0x6f, 0x39,
	0x14, 0xb5, 0xb9, 0xc7, 0x6f, 0x95, 0x4b, 0xa3, 0xc7, 0x47, 0x3f, 0xfa, 0x7f, 0xc7, 0x77, 0xe9,
	0xe1, 0x4f, 0x26, 0x11, 0xf3, 0xc6, 0x87, 0xec, 0xfa, 0xb9, 0xeb, 0x45, 0x8e, 0x7f, 0x4d, 0xc3,
	0xe9, 0x73, 0xad, 0x2a, 0xff, 0x4a, 0xc7, 0xaf, 0x97, 0xcb, 0xe2, 0xfd, 0x93, 0x7f, 0x07, 0x00,
	0x00, 0xff, 0xff, 0x97, 0xbd, 0x04, 0x7d, 0xcf, 0x1e, 0x00, 0x00,
}
