# DNScache

The purpose of this library is to remove dns host lookups from the critical path of a service.
DNScache caches dns lookups and updates the cache asynchronously

## Usage

create a custom transport and override the `DialContext` func like so:

~~~go
import "code.justin.tv/feeds/dnscache"

cache := &dnscache.Cache{
  // Optional field: default is 3 seconds
  Every: 5 * time.Seconds,
  // Optional field
  OnErr: func(err error, host string){ // error handling/logging code here },
  // Optional field
  OnCacheUpsert: func(host string, oldAddrs []string, newAddrs []string, lookupTime time.Duration){
    // custom logs
    // monitoring stats
  }

  // Optional custom dialer: default is
  //  &net.Dialer{
  // Timeout:   30 * time.Second,
  //  KeepAlive: 30 * time.Second,
  //  DualStack: true,
  // })
  Dialer: &net.Dialer{}
}

tr := &http.Transport{
  DialContext: cache.DialContext,
}
~~~

#### Kill Switch

The DNS cache can be turned off remotely via distconf via: `service_common.stop_dns_cache = true`

## Test

make test

