# rollbar

A Go client library for Rollbar.

Forked from github.com/stvp/roll, written with a more Go-ish API 

# Sending messages

The most basic usage is with the message or trace functions directly.

```
    c := rollbar.Client {
        AccessToken: "abcefgh",
    }
    c.Message(context.Background(), rollbar.Info, "Hello world")
```

# Sending errors

You can send errors with the Trace() method.

```
    c := rollbar.Client {
        AccessToken: "abcefgh",
    }
    err := errors.New("a sample error")
    c.Trace(context.Background(), rollbar.Info, err)
```

This method is aware of wrapping libraries for errors.  If
the sent error implements causer, defined below, then that error
will be sent instead

```
	type causer interface {
		Cause() error
	}
```

Trace will also send a stack trace of when the function is called.
If the wrapped error implements any of the following interfaces, then
the stack of the sent error is used instead.  This allows rollbar to record
the location of where the error was created, rather than where it was logged.

```
	type tracedError1 interface {
		StackTrace() []uintptr
	}
	type tracedError2 interface {
		Stack() []uintptr
	}
```

# Setting defaults

You can override the defaults, such as hostname and custom fields,
sent with your message by setting your own message defaults.  MessageOptionals
attached to the client are sent with every request.  Note that if you do
use this feature, you probably want to merge it with the DefaultConfiguration.

```
    c := rollbar.Client {
        AccessToken: "abcefgh",
    }
    newDefaults := &MessageOptionals {
        CodeVersion: "abcdefg",
        Custom: map[string]string {
            "appname": "myservice",
        },
    }
    newDefaults.MergeFrom(&DefaultConfiguration)
    c.MessageDefaults = newDefaults
    c.Message(context.Background(), rollbar.Info, "hello world")
```

# Configuring individual messages

You can use the `MessageBody` and `TraceBody` functions to configure
individual messages.  These bodies can then be sent with `Send` directly.

```
    c := rollbar.Client {
        AccessToken: "abcefgh",
    }
    msgBody := rollbar.MessageBody(rollbar.Warning, "hello world")
    msgBody.Custom = map[string]string {
        "hello": "world1234",
    }
    c.Send(context.Background(), msgBody)
```

# LICENSE

MIT and forked from github.com/stvp/roll