package ec2

import (
	"code.justin.tv/feeds/xray"
	"github.com/aws/aws-sdk-go/aws/ec2metadata"
	"github.com/aws/aws-sdk-go/aws/session"
)

// Plugin allows adding EC2 to xray
type Plugin struct {
}

// ModifyMetadata adds aws ec2 information to each segment created by X-Ray
func (p *Plugin) ModifyMetadata(meta *xray.OptionalMetadata) error {
	client := ec2metadata.New(session.New())
	doc, err := client.GetInstanceIdentityDocument()
	if err != nil {
		return err
	}

	meta.IdentityDocument = &xray.IdentityDocument{
		AccountID:        doc.AccountID,
		InstanceID:       doc.InstanceID,
		AvailabilityZone: doc.AvailabilityZone,
	}
	return nil
}
