package multistatsender

import (
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

// MultiSubStatter wraps multiple SubStatter to do actions on all at once
type MultiSubStatter struct {
	SubStatters []statsd.SubStatter
}

var _ statsd.SubStatter = &MultiSubStatter{}

// SetSamplerFunc on each SubStatters
func (m *MultiSubStatter) SetSamplerFunc(f statsd.SamplerFunc) {
	for _, s := range m.SubStatters {
		s.SetSamplerFunc(f)
	}
}

// NewSubStatter on each SubStatters and returns a wrapper for them all
func (m *MultiSubStatter) NewSubStatter(prefix string) statsd.SubStatter {
	ret := &MultiSubStatter{
		SubStatters: make([]statsd.SubStatter, 0, len(m.SubStatters)),
	}
	for _, s := range m.SubStatters {
		ret.SubStatters = append(ret.SubStatters, s.NewSubStatter(prefix))
	}
	return ret
}

// Inc each SubStatters
func (m *MultiSubStatter) Inc(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Inc(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Dec each SubStatters
func (m *MultiSubStatter) Dec(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Dec(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Gauge each SubStatters
func (m *MultiSubStatter) Gauge(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Gauge(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// GaugeDelta each SubStatters
func (m *MultiSubStatter) GaugeDelta(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.GaugeDelta(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Timing each SubStatters
func (m *MultiSubStatter) Timing(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Timing(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// TimingDuration each SubStatters
func (m *MultiSubStatter) TimingDuration(s string, v time.Duration, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.TimingDuration(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Set each SubStatters
func (m *MultiSubStatter) Set(s string, v string, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Set(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// SetInt each SubStatters
func (m *MultiSubStatter) SetInt(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.SetInt(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Raw each SubStatters
func (m *MultiSubStatter) Raw(s string, v string, r float32) error {
	var err error
	for _, statter := range m.SubStatters {
		if e := statter.Raw(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// MultiStatter can proxy a sent statsd metrics to multiple statsd endpoints
type MultiStatter struct {
	Statters []statsd.Statter
}

var _ statsd.Statter = &MultiStatter{}

// NewSubStatter creates SubStatter that wraps each Statters
func (m *MultiStatter) NewSubStatter(p string) statsd.SubStatter {
	ret := &MultiSubStatter{}
	for _, s := range m.Statters {
		ret.SubStatters = append(ret.SubStatters, s.NewSubStatter(p))
	}
	return ret
}

// SetPrefix on each Statter
func (m *MultiStatter) SetPrefix(p string) {
	for _, s := range m.Statters {
		s.SetPrefix(p)
	}
}

// Close each Statter
func (m *MultiStatter) Close() error {
	var ret error
	for _, s := range m.Statters {
		if err := s.Close(); err != nil {
			ret = err
		}
	}
	return ret
}

// Inc each Statter
func (m *MultiStatter) Inc(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Inc(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Dec each Statter
func (m *MultiStatter) Dec(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Dec(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Gauge each Statter
func (m *MultiStatter) Gauge(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Gauge(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// GaugeDelta each Statter
func (m *MultiStatter) GaugeDelta(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.GaugeDelta(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Timing each Statter
func (m *MultiStatter) Timing(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Timing(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// TimingDuration each Statter
func (m *MultiStatter) TimingDuration(s string, v time.Duration, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.TimingDuration(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Set each Statter
func (m *MultiStatter) Set(s string, v string, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Set(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// SetInt each Statter
func (m *MultiStatter) SetInt(s string, v int64, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.SetInt(s, v, r); e != nil {
			err = e
		}
	}
	return err
}

// Raw each Statter
func (m *MultiStatter) Raw(s string, v string, r float32) error {
	var err error
	for _, statter := range m.Statters {
		if e := statter.Raw(s, v, r); e != nil {
			err = e
		}
	}
	return err
}
