package eventbus

import (
	"context"
	"errors"
	"fmt"

	"github.com/golang/protobuf/proto"
	"github.com/twitchtv/twirp"

	"code.justin.tv/eventbus/schema/pkg/user"
)

type consumer struct {
	EventBusProcessor
}

func NewEventBusConsumer(p EventBusProcessor) (EventBusConsumer, error) {
	if p == nil {
		return nil, errors.New("Missing EventBusProcessor")
	}
	return &consumer{p}, nil
}

func (c *consumer) ConsumeEvent(ctx context.Context, r *ConsumeEventRequest) (*ConsumeEventResponse, error) {
	switch r.GetName() {
	case user.DestroyEventType:
		event := &user.UserDestroy{}
		if err := proto.Unmarshal(r.GetPayload(), event); err != nil {
			return nil, twirp.NewError(twirp.Malformed, err.Error())
		}
		return c.ProcessUserDestroy(ctx, event, r.GetCursor())
	}
	return nil, twirp.NewError(twirp.Unimplemented, fmt.Sprintf("%s is unimplemented", r.GetName()))
}
