# Vapour auth proxy
Current version: 1.1.0  
The auth proxy works by a user connecting turbo-enabled accounts through the `/auth/login` endpoint.  
After that is done, the users refresh token is stored plain-text in the local SQL database.  
That token can then be used, in combination with the auth proxy password (set through an environment variable), to create an oauth token that grants ad-free viewing using the `/auth/refresh` endpoint.  


[TODO](TODO.md)

## Endpoints
### /version
Spits out the current version

### /auth/login
Redirects the user to the twitch login page to authenticate with the auth proxy app, and store the users refresh token in the database

### /auth/refresh
This is the endpoint that internal apps use to make an oauth token for a given user id, with a given password.

### /auth/callback
User is redirected here after finishing up the twitch login flow

## Create database
`CREATE DATABASE vapour_auth_proxy;`

## Available environment variables
### VAPOUR_AUTHPROXY_PATH_PREFIX
Set an optional path prefix for the web route

### VAPOUR_AUTHPROXY_PASSWORD
Set the password required to be able to access tokens  
*TODO: Separate password per userid?*

## External packages used
| Library                | License      | Usage |
| ---------------------- | ------------ | ----- |
| gorilla/mux            | BSD-3-Clause | Routing |
| golang-migrate/migrate | MIT          | Database migrations |
| dankeroni/go-twitch    | MIT          | Twitch API functions |
| go-sql-driver/mysql    | MPL-2.0      | MySQL driver |
