package main

import (
	"fmt"
	"log"
	"os"
)

func main() {
	quitChannel := make(chan bool)

	var err error
	a := newApplication(quitChannel)
	err = a.LoadConfig("config.json")
	if err != nil {
		fmt.Println("Error loading config:", err)
		os.Exit(1)
	}

	err = a.InitializeOAuth2()
	if err != nil {
		fmt.Println("Error initializing OAuth2 config:", err)
		os.Exit(1)
	}

	err = a.InitializeAPIClient()
	if err != nil {
		fmt.Println("Error initializing API client:", err)
		os.Exit(1)
	}

	err = a.InitializeSQLClient()
	if err != nil {
		fmt.Println("Error initializing SQL client:", err)
		os.Exit(1)
	}

	err = a.RunMigrations()
	if err != nil {
		fmt.Println("Error running SQL migrations:", err)
		os.Exit(1)
	}

	err = a.LoadUsers()
	if err != nil {
		fmt.Println("Error loading users:", err)
	}

	err = a.RunWeb()
	if err != nil {
		fmt.Println("Error running web:", err)
	}

	log.Println("Vapour Authproxy version", versionString, "running")

	// TODO: Clear the state store occasionally

	<-quitChannel
}
