package config

import (
	"encoding/json"
	"io/ioutil"
)

type SQLConfig struct {
	DSN string
}

type AppConfig struct {
	ClientID     string
	ClientSecret string
	RedirectURL  string
}

type WebConfig struct {
	Host string
}

type Config struct {
	SQL SQLConfig

	App AppConfig

	Web WebConfig
}

func LoadConfig(path string) (*Config, error) {
	file, err := ioutil.ReadFile(path)
	if err != nil {
		return nil, err
	}
	config := &Config{}
	err = json.Unmarshal(file, config)
	if err != nil {
		return nil, err
	}

	return config, nil
}
