package state

import (
	"crypto/rand"
	"encoding/hex"
	"errors"
	"time"
)

const expiryDuration = 5 * time.Minute

type State struct {
	value     string
	expiresAt time.Time
}

func New() (*State, error) {
	var tokenBytes [255]byte
	if _, err := rand.Read(tokenBytes[:]); err != nil {
		return nil, errors.New("Unable to generate random bytes")
	}

	value := hex.EncodeToString(tokenBytes[:])
	return &State{
		value:     value,
		expiresAt: time.Now().Add(expiryDuration),
	}, nil
}

func (s State) Value() string {
	return s.value
}

func (s State) Expired() bool {
	return time.Now().After(s.expiresAt)
}
