package statestore

import (
	"sync"

	"code.justin.tv/vapour/authproxy/pkg"
)

type StateStore struct {
	dataMutex *sync.Mutex
	data      []pkg.State
}

func New() *StateStore {
	return &StateStore{
		dataMutex: &sync.Mutex{},
	}
}

func (ss *StateStore) Add(state pkg.State) {
	ss.dataMutex.Lock()
	defer ss.dataMutex.Unlock()

	ss.data = append(ss.data, state)
}

func (ss *StateStore) Check(value string) bool {
	ss.dataMutex.Lock()
	defer ss.dataMutex.Unlock()

	for i := range ss.data {
		if ss.data[i].Value() == value {
			ss.data[i] = ss.data[len(ss.data)-1]
			ss.data[len(ss.data)-1] = nil
			ss.data = ss.data[:len(ss.data)-1]
			return true
		}
	}

	return false
}

// Clear clears the state store of any expired states
func (ss *StateStore) Clear() {
	ss.dataMutex.Lock()
	defer ss.dataMutex.Unlock()

	var newData []pkg.State

	for _, state := range ss.data {
		if !state.Expired() {
			newData = append(newData, state)
		}
	}

	ss.data = newData
}
