package pkg

import (
	"database/sql"
	"time"

	"golang.org/x/oauth2"
)

type User interface {
	ID() string
	Login() string
	SaveToDB(*sql.DB) error
	Token() (*oauth2.Token, error)
}

// Publicly available user data. this struct is jsonified as a web response
type UserToken struct {
	UserID      string
	AccessToken string
	Expiry      time.Time
}
