#include "browser/browser.hpp"
#include "browser/browseritem.hpp"
#include "browser/browsermodel.hpp"

#include <QString>
#include <QTreeView>
#include <QVariant>

namespace Vape {
namespace Browser {

BrowserModel model;
bool initialized = false;

void
init(QTreeView *treeView)
{
    // Make sure Browser::init is only called once
    assert(!initialized);

    model.setTreeView(treeView);

    initialized = true;
}

BrowserItem *
get(const char *path)
{
    return model.getRoot(path);
}

void
create(const char *path, const QString &key, const QVariant &value)
{
    model.createRoot(path, key, value);
}

bool
softCreate(const char *path, const QString &key, const QVariant &value)
{
    auto x = get(path);
    if (x == nullptr) {
        create(path, key, value);

        return true;
    }

    return false;
}

}  // namespace Browser
}  // namespace Vape
