# Files
Below are all files included in the project, with a description of their purpose.

## .manta.json
**INCLUDED IN install.sh**  
Stores information for how to build the application. Should not need to be customized.

## jenkins.groovy
**INCLUDED IN install.sh**  
Stores information for the jobs that should be run on commit for this repository. Should not need to be customized.

## utils/config.sh
**SHOULD BE FILLED OUT BY YOUR PROJECT**

## CMakeLists.txt
You need to create and set this up to fit your project.

## utils/setup.sh
**INCLUDED IN install.sh**  
Sets the repository up, does anything you might need from Jenkins (e.g. `git submodule update --init --recursive`).  
This is the first script that's called in CI.

## utils/(pre/post)setup.sh
Scripts called before or after setup.sh has been called in the CI.  
These scripts are run in Jenkins.

## utils/manta.sh
**INCLUDED IN install.sh**  
This runs manta (which runs a docker image and runs the build script).  
This is the second script that's called in CI.

## utils/(pre/post)manta.sh
Scripts called before or after manta.sh has been called in the CI.  
These scripts are run in manta.

## utils/deploy.sh
**INCLUDED IN install.sh**  
This runs the deploy script, which attempts to deploy the resulting binary/folder to s3.  
This is the third script that's called in CI (Only on `release/`-branches).  

## utils/(pre/post)deploy.sh
**THE predeploy.sh SCRIPT MUST BE CREATED FOR deploy.sh TO WORK**  
Scripts called before or after deploy.sh has been called in the CI.  
These scripts are run in Jenkins.

## utils/update-internal.sh
**INCLUDED IN install.sh**  
Updates all internal repositories.

## utils/build.sh
**INCLUDED IN install.sh**  
Script used to build the project. Used in the CI, but can also be used manually to build.

## utils/docker/image.sh
**INCLUDED IN install.sh**  
Creates the docker image for this project according to `.docker/Dockerfile.build`.

## utils/docker/push.sh
**INCLUDED IN install.sh**  
Pushes the docker image created by `docker/image.sh` to Twitch's internal docker registry.

## utils/docker/build.sh
**INCLUDED IN install.sh**  
Attempt to build the project using the docker image.

## utils/safe-exec.sh
**INCLUDED IN install.sh**  
Used to run optional pre/post scripts.
