#!/usr/bin/env python3

import sys
import cmakelists_parsing.parsing as cmp

target_cmake_version = "3.16"
g_required_sets = {"VAPOUR_CXX_VERSION"}
path_prefix_trim = "/home/pajlada/work/cpp/"

def error(data, message):
    print(f"{data['path']}: {message}")

def error_mm(data, name, actual, expected):
    print(f"{data['path']}: wrong {name}. is {actual} but should be {expected}")

def validate_cmake_minimum_required(l, data):
    minimum_required_version = l.body[1].contents

    if minimum_required_version != target_cmake_version:
        error_mm(data, "minimum required version", minimum_required_version, target_cmake_version)

def validate_set(l, data):
    if l.body[0].contents == "ProjectName":
        error(data, "The variable ProjectName should never be set. Use PROJECT_NAME instead")

def check(path):
    data = {
            "path": path.removeprefix(path_prefix_trim),
            }

    required_sets = g_required_sets

    try:
        with open(path, 'r') as f:
            cmake_data = cmp.parse(f.read())
            for l in cmake_data:
                if type(l) is not cmp._Command:
                    continue

                key = f"validate_{l.name}"

                if key in globals():
                    globals()[key](l, data)

                if l.name == 'set':
                    v_name = l.body[0].contents
                    required_sets.discard(v_name)

    except FileNotFoundError:
        return

    for k in required_sets:
        error(data, f"Missing set for variable {k}")

if __name__ == '__main__':
    if len(sys.argv) < 2:
        print(f"USAGE: {sys.argv[0]} <PATH_TO_CMAKELISTS.TXT>")
        sys.exit(1)

    check(sys.argv[1])
