#!/bin/sh

set -e

usage() {
    >&2 echo "Usage: $0 target_dir"
    exit 1
}

source_utils_dir=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
source_docker_dir="$source_utils_dir/../.docker"

. "$source_utils_dir/"ci-test-utils/shared.sh

for i in "$@"; do
	case $i in
		--help)
            usage
			shift
			;;
		*)
			# unknown option
			;;
	esac
done

source_dir="$(realpath "$source_utils_dir/..")"
target_dir=$1

verify_target_dir "$target_dir" || usage

target_app_name=$(basename "$(emulate_realpath "$target_dir")")
target_utils_dir="$target_dir/utils"
target_utils_docker_dir="$target_dir/utils/docker"
target_docker_dir="$target_dir/.docker"
target_docs_dir="$target_dir/docs"

"$source_utils_dir/.cmakelists-check.py" "$target_dir/CMakeLists.txt"
"$source_utils_dir/.cmakelists-check.py" "$target_dir/example/CMakeLists.txt"
"$source_utils_dir/.cmakelists-check.py" "$target_dir/tests/CMakeLists.txt"
