#!/bin/sh

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/../config.sh"

for dockerfile in .docker/Dockerfile.*; do
    dockerfile_type=$(echo "$dockerfile" |awk -F . '{if (NF>1) {print $NF}}')
    if [ -z "$dockerfile_type" ]; then
        echo " ! Not a valid dockerfile name: $dockerfile"
        continue
    fi
    echo " * Building docker image for $dockerfile_type at path '$dockerfile'"
    docker build -t vapour/"$appname"-"$dockerfile_type" -f "$dockerfile" .
done
