set(VapourFundamentals_INCLUDE_DIRS
    ${CMAKE_CURRENT_LIST_DIR}/include
    )

if(VAPOUR_RAPIDJSON)
    message(STATUS "Enabling vapour RapidJSON")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/rapidjson-helpers.cpp
        )
endif()

if(VAPOUR_ENV)
    message(STATUS "Enabling vapour environment")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/environment-args.cpp
        )
endif()

if(VAPOUR_APP)
    message(STATUS "Enabling vapour app")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/iapplication.cpp
        )
endif()

if(VAPOUR_PUBSUB_HELPERS)
    message(STATUS "Enabling vapour pubsub helpers")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/pubsub-helpers.cpp
        ${CMAKE_CURRENT_LIST_DIR}/src/settings-common.cpp
        )
endif()

if(VAPOUR_WS)
    message(STATUS "Enabling vapour ws")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/websocket-helpers.cpp
        )
endif()

if(VAPOUR_GPU)
    message(STATUS "Enabling vapour gpu")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/gpu.cpp
        )
endif()

if(VAPOUR_DECKLINK)
    message(STATUS "Enabling vapour DeckLink support")
    list(APPEND VapourFundamentals_SOURCES
        ${CMAKE_CURRENT_LIST_DIR}/src/decklink.cpp
        )
endif()
