#pragma once

#include <functional>

namespace Vape {

// The following two functions are stolen from https://stackoverflow.com/questions/38680931/omit-stdplaceholders-in-stdbind
template <class C, typename Ret, typename... Ts>
constexpr auto
bind_this(C *c, Ret (C::*m)(Ts...))
{
    return [=](auto &&... args) { return (c->*m)(std::forward<decltype(args)>(args)...); };
}

template <class C, typename Ret, typename... Ts>
constexpr auto
bind_this(const C *c, Ret (C::*m)(Ts...) const)
{
    return [=](auto &&... args) { return (c->*m)(std::forward<decltype(args)>(args)...); };
}

}  // namespace Vape
