#pragma once

#include "decklink_platform.h"

#include <functional>

namespace Vape {

template <typename DeckLinkClass>
struct ScopedDeckLinkPointer {
    DeckLinkClass *scopedPointer{nullptr};

    ScopedDeckLinkPointer(DeckLinkClass *_scopedPointer)
        : scopedPointer(_scopedPointer)
    {
    }

    ScopedDeckLinkPointer(const ScopedDeckLinkPointer &o)
        : scopedPointer(o.scopedPointer)
    {
        this->scopedPointer->AddRef();
    }

    ScopedDeckLinkPointer &operator=(const ScopedDeckLinkPointer &) = delete;

    ~ScopedDeckLinkPointer()
    {
        if (this->scopedPointer != nullptr) {
            this->scopedPointer->Release();
        }
    }
};

IDeckLinkOutput *GetDeckLinkOutput(int index);

IDeckLinkConfiguration *GetDeckLinkConfiguration(IDeckLinkOutput *deckLinkOutput);
IDeckLinkAttributes *GetDeckLinkAttributes(IDeckLinkOutput *deckLinkOutput);
bool CheckDeckLinkAttribute(IDeckLinkAttributes *attributes, BMDDeckLinkAttributeID attrID);
bool UpdateDeckLinkConfigurationFlag(IDeckLinkConfiguration *configuration,
                                     BMDDeckLinkConfigurationID cfgID, bool val);
bool UpdateDeckLinkConfigurationInt(IDeckLinkConfiguration *configuration,
                                    BMDDeckLinkConfigurationID cfgID, int val);

void OnAllDeckLinkOutputs(const std::function<void(IDeckLinkOutput *, std::string)> &cb);

}  // namespace Vape
