#pragma once

#include "fundamentals/ipathstorage.hpp"

#include <boost/any.hpp>
#include <boost/optional.hpp>
#include <rapidjson/document.h>

#include <memory>

namespace pajlada {
namespace Settings {

class SettingData;

}  // namespace Settings
}  // namespace pajlada

namespace Vape {

// A deserializable object is an object that can be deserialized from a JSON Value
// to update the underlying C++ object
class IDeserializable : public IPathStorage
{
public:
    IDeserializable() = delete;

    explicit IDeserializable(const std::string &_path, bool _remoteReadOnly, bool _remoteTemporary);
    IDeserializable(const IDeserializable &other);
    virtual ~IDeserializable();

    virtual void Deserialize(const rapidjson::Value &value, boost::any userData = boost::any()) = 0;
    virtual void DeserializeMember(const std::string &member, const rapidjson::Value &value,
                                   boost::any userData = boost::any())                          = 0;

    virtual std::weak_ptr<pajlada::Settings::SettingData> GetSetting() = 0;
    virtual void ResetToDefaultValue()                                 = 0;

    void PushDeserializableRegistered();
    void PushDeserializableUnregistered();

private:
    virtual void OnConstructed();
    virtual void OnDestructed();
};

}  // namespace Vape
