#pragma once

#include <QApplication>
#include <QLibrary>

namespace Vape {

inline void
FixDPI()
{
    QApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

#ifdef _WIN32
    {
        typedef BOOL (*SetProcessDpiAwarenessT)(int value);
        QLibrary user32("user32.dll", NULL);
        SetProcessDpiAwarenessT SetProcessDpiAwarenessD =
            (SetProcessDpiAwarenessT)user32.resolve("SetProcessDpiAwarenessInternal");
        if (SetProcessDpiAwarenessD != nullptr) {
            SetProcessDpiAwarenessD(1);  //PROCESS_SYSTEM_DPI_AWARE
        }
    }
#endif
}

}  // namespace Vape
