#pragma once

#include "fundamentals/string-helpers.hpp"

#include <string>

namespace Vape {

static constexpr char LOCAL_PREFIX_CHARACTER = '@';

template <typename T>
bool
FlagActive(uint64_t bitfield, T flag)
{
    uint64_t ret = bitfield & static_cast<uint64_t>(flag);

    return ret != 0;
}

struct ParentPathResult {
    std::string path;
    std::string member;
    bool error = false;
};

inline ParentPathResult
GetParentPath(const std::string &path)
{
    ParentPathResult res;

    // Path is empty, there's no parent to be found
    if (path.empty()) {
        res.error = true;
        return res;
    }

    // Path ends with a /, we consider this to be an invalid setter path
    if (EndsWithChar(path, '/')) {
        res.error = true;
        return res;
    }

    auto lastSplit = path.rfind('/');
    if (lastSplit == std::string::npos || lastSplit == path.size()) {
        res.error = true;
        return res;
    }

    res.member = path.substr(lastSplit + 1);
    res.path   = path.substr(0, lastSplit);

    return res;
}

}  // namespace Vape
