#pragma once

#include "network/vector.hpp"
#include "vapour/vapour_types.h"

namespace Vape {

struct OpenGLTextureParams {
    int internalFormat;
    int pixelFormat;
    int type;
    bool isSRGB;
};

struct DX9TextureParams {
    int dxFormat;
};

struct DX11TextureParams {
    int dxFormat;
};

bool GetOpenGLTextureParams(const VapourPixelFormat pixelFormat, OpenGLTextureParams &params);
bool GetDX9TextureParams(const VapourPixelFormat pixelFormat, DX9TextureParams &params);
bool GetDX11TextureParams(const VapourPixelFormat pixelFormat, DX11TextureParams &params);

size_t SizeFromPixelFormat(Resolution virtualResolution, VapourPixelFormat pixelFormat);
int ChannelCountFromPixelFormat(VapourPixelFormat pixelFormat);

}  // namespace Vape
