#pragma once

#include "fundamentals/ipollable.hpp"

#include <atomic>
#include <chrono>
#include <string>
#include <vector>

namespace Vape {

class IApplication
{
public:
    virtual ~IApplication() = default;

    virtual void Start();

    // Mark the application as being exited
    // If the application is started, call stop
    virtual void Exit();

    void Poll();

    // Returns true if the application is being exited
    // This will return true if exit has been called
    static bool IsExiting();

protected:
    std::chrono::microseconds eventLoopSleepDuration{500};

    // For Windows, this will disable CTRL+C entirely.
    // This calls the virtual method Exit that you can override to do anything you'd like
    void HandleConsoleExit();

public:
    std::vector<std::reference_wrapper<IPollable>> pollable;
};

}  // namespace Vape
