#pragma once

#include <net/if.h>

namespace Vape {

// GetNetworkInterfaceIndex returns the index of the given network interface, or -1 if the interface was not found
// XXX: This might be unix-specific
inline int
GetNetworkInterfaceIndex(const char *name)
{
    auto *ifBegin      = if_nameindex();
    int interfaceIndex = -1;

    if (ifBegin == nullptr) {
        return interfaceIndex;
    };

    for (auto *iface = ifBegin; iface->if_index != 0 || iface->if_name != nullptr; iface++) {
        if (strcmp(iface->if_name, name) == 0) {
            interfaceIndex = iface->if_index;
            break;
        }
    }

    if_freenameindex(ifBegin);

    return interfaceIndex;
}

}  // namespace Vape
