#pragma once

#include <mutex>
#include <shared_mutex>

namespace Vape {

template <typename T>
class LockedValue
{
public:
    void
    Set(T newValue)
    {
        std::unique_lock lock(this->mutex);

        this->value = newValue;
    }

    T
    Get()
    {
        std::shared_lock lock(this->mutex);

        return this->value;
    }

private:
    std::shared_mutex mutex;
    T value;
};

}  // namespace Vape
