#pragma once

namespace Vape {

class NoCopy
{
protected:
    NoCopy()  = default;
    ~NoCopy() = default;

    NoCopy(const NoCopy &) = delete;
    NoCopy &operator=(const NoCopy &) = delete;
};

// NoMove also implies no copy
class NoMove
{
protected:
    NoMove()  = default;
    ~NoMove() = default;

    NoMove(const NoMove &) = delete;
    NoMove &operator=(const NoMove &) = delete;

    NoMove(NoMove &&) noexcept = delete;
    NoMove &operator=(NoMove &&) noexcept = delete;
};

}  // namespace Vape
