#pragma once

namespace Vape {

inline std::string
FileExtension(const std::string &path)
{
    if (path.size() < 2) {
        return "";
    }

    const auto pos = path.rfind('.');
    if (pos == std::string::npos || pos == path.size() - 1) {
        return "";
    }

    return path.substr(pos + 1);
}

}  // namespace Vape
