#pragma once

#include "fundamentals/time-helpers.hpp"

#include <chrono>

namespace Vape {

class ProfilingTimer
{
public:
    using Clock = std::chrono::steady_clock;

    Clock::duration
    GetTime()
    {
        return Clock::now() - startTime;
    }

    Clock::time_point
    GetStartTime()
    {
        return startTime;
    }

    float
    GetFloatTime()
    {
        return Time::ToFloat(this->GetTime());
    }

    auto
    GetMilliseconds()
    {
        auto time = this->GetTime();

        return std::chrono::duration_cast<std::chrono::milliseconds>(time).count();
    }

    auto
    GetMicroseconds()
    {
        auto time = this->GetTime();

        return std::chrono::duration_cast<std::chrono::microseconds>(time).count();
    }

private:
    const Clock::time_point startTime{Clock::now()};
};

}  // namespace Vape
