#pragma once

#include "fundamentals/rapidjson.hpp"

#include <rapidjson/document.h>

namespace Vape {

class ISerializable;

rapidjson::Document CreatePublishMessage(const std::string &topic);
RJDocument CreatePublishMessage2(const std::string &topic);

// Used in the one and only true setting source
rapidjson::Document CreateValueUpdatedMessage(const ISerializable &serializable);
rapidjson::Document CreateValueRemovedMessage(const ISerializable &serializable);

// Used as actions from any external source
rapidjson::Document CreateSetValueMessage(const ISerializable &serializable);
rapidjson::Document CreateRegisterValueMessage(const ISerializable &serializable);

rapidjson::Value CreateSerializableValue(const ISerializable &serializable,
                                         rapidjson::Document::AllocatorType &a);

}  // namespace Vape
