#pragma once

#include <rapidjson/document.h>
#include <rapidjson/pointer.h>

namespace Vape {

// Using these RapidJSON types will make the allocator constantly allocate/free memory. Useful for long-living RapidJSON objects.
using RJDocument = rapidjson::GenericDocument<rapidjson::UTF8<>, rapidjson::CrtAllocator>;
using RJValue    = RJDocument::ValueType;
using RJPointer  = rapidjson::GenericPointer<RJValue>;

// Using these RapidJSON types will make the allocator NOT free memory during use, but only when the object is destructed.
using ShortLivedRJDocument = rapidjson::Document;
using ShortLivedRJValue    = ShortLivedRJDocument::ValueType;
using ShortLivedRJPointer  = rapidjson::GenericPointer<ShortLivedRJValue>;

}  // namespace Vape
