#pragma once

#include "fundamentals/ipathstorage.hpp"

#include <rapidjson/document.h>

namespace pajlada::Settings {

struct SignalArgs;

}  // namespace pajlada::Settings

namespace Vape {

// A serializable object is an object that can be serialized from a C++ object
// to a JSON value with a given RapidJSON document allocator
class ISerializable : public IPathStorage
{
public:
    ISerializable() = delete;

    explicit ISerializable(const std::string &_path, bool _remoteReadOnly, bool _remoteTemporary);
    ISerializable(const ISerializable &other);
    virtual ~ISerializable();

    virtual rapidjson::Value Serialize(rapidjson::Document::AllocatorType &a) const = 0;

protected:
    void PushObjectValueUpdated(const pajlada::Settings::SignalArgs &args);

    void PushSerializableRegistered();
    void PushSerializableUnregistered();

private:
    virtual void OnConstructed();
    virtual void OnDestructed();
};

}  // namespace Vape
