#pragma once

#include "fundamentals/objectstore.hpp"
#include "fundamentals/serializable.hpp"

#include <pajlada/settings/signalargs.hpp>
#include <pajlada/signals/signal.hpp>

namespace Vape {

class SerializableStore : public ObjectStore<ISerializable>
{
public:
    static SerializableStore &
    serializableInstance()
    {
        static SerializableStore i;

        return i;
    }

    pajlada::Signals::Signal<const ISerializable &, const pajlada::Settings::SignalArgs &>
        serializableChanged;

    std::vector<const ISerializable *> GetObjectsMatchingPath(const std::string &listenerPath);
};

}  // namespace Vape
