#pragma once

#include <chrono>

namespace Vape {
namespace Time {

template <typename Rep, typename Period>
static inline float
ToFloat(const std::chrono::duration<Rep, Period> &duration)
{
    return std::chrono::duration_cast<std::chrono::duration<float>>(duration).count();
}

}  // namespace Time
}  // namespace Vape
