#pragma once

#include <string>

namespace Vape {

// Shamelessly stolen from https://stackoverflow.com/q/4484982
#define ENABLE_TYPENAME(A)            \
    template <>                       \
    struct TypeName<A> {              \
        static constexpr const char * \
        get()                         \
        {                             \
            return #A;                \
        }                             \
    };

#define ENABLE_TYPENAME2(A, str)      \
    template <>                       \
    struct TypeName<A> {              \
        static constexpr const char * \
        get()                         \
        {                             \
            return str;               \
        }                             \
    };

template <typename Type>
struct TypeName {
    static constexpr const char *
    get()
    {
        return "?";
    }
};

ENABLE_TYPENAME(int)
ENABLE_TYPENAME2(std::string, "string")
ENABLE_TYPENAME(float)
ENABLE_TYPENAME(double)

}  // namespace Vape
