#include "fundamentals/deserializable.hpp"

#include "fundamentals/common.hpp"
#include "fundamentals/deserializablestore.hpp"
#include "fundamentals/helpers.hpp"
#include "fundamentals/rapidjson-helpers.hpp"

#include <pajlada/settings/settingdata.hpp>

namespace Vape {

IDeserializable::IDeserializable(const std::string &_path, bool _remoteReadOnly,
                                 bool _remoteTemporary)
    : IPathStorage(_path, _remoteReadOnly, _remoteTemporary)
{
    this->OnConstructed();
}

IDeserializable::IDeserializable(const IDeserializable &other)
    : IPathStorage(static_cast<const IPathStorage &>(other))
{
    this->OnConstructed();
}

IDeserializable::~IDeserializable()
{
    this->OnDestructed();
}

void
IDeserializable::PushDeserializableRegistered()
{
    DeserializableStore::deserializableInstance().objectRegistered.invoke(this);
}

void
IDeserializable::PushDeserializableUnregistered()
{
    DeserializableStore::deserializableInstance().objectUnregistered.invoke(this);
}

void
IDeserializable::OnConstructed()
{
    // Register to DeserializableStore
    DeserializableStore::deserializableInstance().doRegister(this);
}

void
IDeserializable::OnDestructed()
{
    // Unregister from DeserializableStore
    DeserializableStore::deserializableInstance().doUnregister(this);
}

}  // namespace Vape
